/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTRNPCTargetSelector;
import lotr.common.entity.npc.LOTRBoss;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.tuple.Pair;

public class LOTRBossInfo {
    private LOTREntityNPC theNPC;
    private LOTRBoss theBoss;
    public EntityPlayer lastAttackingPlayer;
    private Map<UUID, Pair<Integer, Float>> playerHurtTimes = new HashMap<UUID, Pair<Integer, Float>>();
    private static int PLAYER_HURT_COOLDOWN = 600;
    private static float PLAYER_DAMAGE_THRESHOLD = 40.0f;
    public boolean jumpAttack;

    public LOTRBossInfo(LOTRBoss boss) {
        this.theBoss = boss;
        this.theNPC = (LOTREntityNPC)((Object)this.theBoss);
    }

    public float getHealthChanceModifier() {
        float f = 1.0f - this.theNPC.func_110143_aJ() / this.theNPC.func_110138_aP();
        return MathHelper.func_76129_c((float)f);
    }

    public List getNearbyEnemies() {
        ArrayList<EntityPlayer> enemies = new ArrayList<EntityPlayer>();
        List players = this.theNPC.field_70170_p.func_72872_a(EntityPlayer.class, this.theNPC.field_70121_D.func_72314_b(12.0, 6.0, 12.0));
        for (Object player : players) {
            EntityPlayer entityplayer = (EntityPlayer)player;
            if (entityplayer.field_71075_bZ.field_75098_d || LOTRLevelData.getData(entityplayer).getAlignment(this.theNPC.getFaction()) >= 0.0f) continue;
            enemies.add(entityplayer);
        }
        enemies.addAll(this.theNPC.field_70170_p.func_82733_a(EntityLiving.class, this.theNPC.field_70121_D.func_72314_b(12.0, 6.0, 12.0), (IEntitySelector)new LOTRNPCTargetSelector((EntityLiving)this.theNPC)));
        return enemies;
    }

    public void doJumpAttack(double jumpSpeed) {
        this.jumpAttack = true;
        this.theNPC.field_70181_x = jumpSpeed;
    }

    public void doTargetedJumpAttack(double jumpSpeed) {
        if (!this.theNPC.field_70170_p.field_72995_K && this.lastAttackingPlayer != null && (this.lastAttackingPlayer.field_70163_u - this.theNPC.field_70163_u > 10.0 || this.theNPC.func_70068_e((Entity)this.lastAttackingPlayer) > 400.0) && this.theNPC.field_70122_E) {
            this.doJumpAttack(jumpSpeed);
            this.theNPC.field_70159_w = this.lastAttackingPlayer.field_70165_t - this.theNPC.field_70165_t;
            this.theNPC.field_70181_x = this.lastAttackingPlayer.field_70163_u - this.theNPC.field_70163_u;
            this.theNPC.field_70179_y = this.lastAttackingPlayer.field_70161_v - this.theNPC.field_70161_v;
            this.theNPC.field_70159_w /= 10.0;
            this.theNPC.field_70181_x /= 10.0;
            this.theNPC.field_70179_y /= 10.0;
            if (this.theNPC.field_70181_x < jumpSpeed) {
                this.theNPC.field_70181_x = jumpSpeed;
            }
            this.theNPC.func_70671_ap().func_75651_a((Entity)this.lastAttackingPlayer, 100.0f, 100.0f);
            this.theNPC.func_70671_ap().func_75649_a();
            this.theNPC.field_70177_z = this.theNPC.field_70759_as;
        }
    }

    public float onFall(float fall) {
        if (!this.theNPC.field_70170_p.field_72995_K && this.jumpAttack) {
            fall = 0.0f;
            this.jumpAttack = false;
            List enemies = this.getNearbyEnemies();
            float attackDamage = (float)this.theNPC.func_110148_a(LOTREntityNPC.npcAttackDamage).func_111126_e();
            for (Object enemie : enemies) {
                EntityLivingBase entity = (EntityLivingBase)enemie;
                float strength = 12.0f - this.theNPC.func_70032_d((Entity)entity) / 3.0f;
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.theNPC), (strength /= 12.0f) * attackDamage * 3.0f);
                float knockback = strength * 3.0f;
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.theNPC.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.25 * (double)knockback, (double)(MathHelper.func_76134_b((float)(this.theNPC.field_70177_z * (float)Math.PI / 180.0f)) * knockback * 0.5f));
            }
            this.theBoss.onJumpAttackFall();
        }
        return fall;
    }

    private void clearSurroundingBlocks() {
        if (LOTRMod.canGrief(this.theNPC.field_70170_p)) {
            int xzRange = MathHelper.func_76123_f((float)(this.theNPC.field_70130_N / 2.0f * 1.5f));
            int yRange = MathHelper.func_76123_f((float)(this.theNPC.field_70131_O * 1.5f));
            int xzDist = xzRange * xzRange + xzRange * xzRange;
            int i = MathHelper.func_76128_c((double)this.theNPC.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.theNPC.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.theNPC.field_70161_v);
            for (int i1 = i - xzRange; i1 <= i + xzRange; ++i1) {
                for (int j1 = j; j1 <= j + yRange; ++j1) {
                    for (int k1 = k - xzRange; k1 <= k + xzRange; ++k1) {
                        float f;
                        Block block;
                        int i2 = i1 - i;
                        int k2 = k1 - k;
                        int dist = i2 * i2 + k2 * k2;
                        if (dist >= xzDist || (block = this.theNPC.field_70170_p.func_147439_a(i1, j1, k1)) == null || block.func_149688_o().func_76224_d()) continue;
                        float resistance = block.getExplosionResistance((Entity)this.theNPC, this.theNPC.field_70170_p, i1, j1, k1, this.theNPC.field_70165_t, this.theNPC.field_70121_D.field_72338_b + (double)(this.theNPC.field_70131_O / 2.0f), this.theNPC.field_70161_v);
                        if (f >= 2000.0f) continue;
                        block.func_149690_a(this.theNPC.field_70170_p, i1, j1, k1, this.theNPC.field_70170_p.func_72805_g(i1, j1, k1), resistance / 100.0f, 0);
                        this.theNPC.field_70170_p.func_147468_f(i1, j1, k1);
                    }
                }
            }
        }
    }

    public void onUpdate() {
        if (this.lastAttackingPlayer != null && (!this.lastAttackingPlayer.func_70089_S() || this.lastAttackingPlayer.field_71075_bZ.field_75098_d)) {
            this.lastAttackingPlayer = null;
        }
        if (!this.theNPC.field_70170_p.field_72995_K) {
            HashMap<UUID, Pair<Integer, Float>> playerHurtTimes_new = new HashMap<UUID, Pair<Integer, Float>>();
            for (Map.Entry<UUID, Pair<Integer, Float>> entry : this.playerHurtTimes.entrySet()) {
                UUID player = entry.getKey();
                int time = (Integer)entry.getValue().getLeft();
                float damage = ((Float)entry.getValue().getRight()).floatValue();
                if (--time <= 0) continue;
                playerHurtTimes_new.put(player, (Pair<Integer, Float>)Pair.of((Object)time, (Object)Float.valueOf(damage)));
            }
            this.playerHurtTimes = playerHurtTimes_new;
        }
        if (!this.theNPC.field_70170_p.field_72995_K && this.jumpAttack && this.theNPC.field_70173_aa % 5 == 0) {
            this.clearSurroundingBlocks();
        }
    }

    public void onHurt(DamageSource damagesource, float f) {
        if (!this.theNPC.field_70170_p.field_72995_K) {
            EntityPlayer playerSource;
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer attackingPlayer = (EntityPlayer)damagesource.func_76346_g();
                if (!attackingPlayer.field_71075_bZ.field_75098_d) {
                    this.lastAttackingPlayer = attackingPlayer;
                }
            }
            if ((playerSource = LOTRMod.getDamagingPlayerIncludingUnits(damagesource)) != null) {
                UUID player = playerSource.func_110124_au();
                int time = PLAYER_HURT_COOLDOWN;
                float totalDamage = f;
                if (this.playerHurtTimes.containsKey(player)) {
                    Pair<Integer, Float> pair = this.playerHurtTimes.get(player);
                    totalDamage += ((Float)pair.getRight()).floatValue();
                }
                this.playerHurtTimes.put(player, (Pair<Integer, Float>)Pair.of((Object)time, (Object)Float.valueOf(totalDamage)));
            }
        }
    }

    public void onDeath(DamageSource damagesource) {
        this.onHurt(damagesource, 0.0f);
        if (!this.theNPC.field_70170_p.field_72995_K) {
            for (Map.Entry<UUID, Pair<Integer, Float>> e : this.playerHurtTimes.entrySet()) {
                UUID player = e.getKey();
                Pair<Integer, Float> pair = e.getValue();
                float damage = ((Float)pair.getRight()).floatValue();
                if (damage < PLAYER_DAMAGE_THRESHOLD) continue;
                LOTRLevelData.getData(player).addAchievement(this.theBoss.getBossKillAchievement());
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        NBTTagList playerHurtTags = new NBTTagList();
        for (Map.Entry<UUID, Pair<Integer, Float>> entry : this.playerHurtTimes.entrySet()) {
            UUID player = entry.getKey();
            Pair<Integer, Float> pair = entry.getValue();
            int time = (Integer)pair.getLeft();
            float damage = ((Float)pair.getRight()).floatValue();
            NBTTagCompound playerTag = new NBTTagCompound();
            playerTag.func_74778_a("UUID", player.toString());
            playerTag.func_74768_a("Time", time);
            playerTag.func_74776_a("Damage", damage);
            playerHurtTags.func_74742_a((NBTBase)playerTag);
        }
        data.func_74782_a("PlayerHurtTimes", (NBTBase)playerHurtTags);
        data.func_74757_a("JumpAttack", this.jumpAttack);
        nbt.func_74782_a("NPCBossInfo", (NBTBase)data);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("NPCBossInfo");
        if (data != null) {
            NBTTagList playerHurtTags = data.func_150295_c("PlayerHurtTimes", 10);
            for (int i = 0; i < playerHurtTags.func_74745_c(); ++i) {
                NBTTagCompound playerTag = playerHurtTags.func_150305_b(i);
                UUID player = UUID.fromString(playerTag.func_74779_i("UUID"));
                if (player == null) continue;
                int time = playerTag.func_74762_e("Time");
                float damage = playerTag.func_74760_g("Damage");
                this.playerHurtTimes.put(player, (Pair<Integer, Float>)Pair.of((Object)time, (Object)Float.valueOf(damage)));
            }
            this.jumpAttack = data.func_74767_n("JumpAttack");
        }
    }
}

